




















 




#pragma language=extended
 

__no_init volatile __nonbanked  unsigned char INDF   @ 0x00;
__no_init volatile __bank0      unsigned char TMR0   @ 0x01;
__no_init volatile __nonbanked  unsigned char PCL    @ 0x02;
__no_init volatile __nonbanked  union 
{
  unsigned char STATUS;
  struct 
  {
    unsigned char C:1;
    unsigned char DC:1;
    unsigned char Z:1;
    unsigned char PD:1;
    unsigned char TO:1;
    unsigned char RP0:1;
    unsigned char RP1:1;
    unsigned char IRP:1;
  };
} @ 0x03;
__no_init volatile __nonbanked  unsigned char FSR    @ 0x04;
__no_init volatile __bank0  union
{
  unsigned char PORTA;
  struct
  {
    unsigned char RA0:1;
    unsigned char RA1:1;
    unsigned char RA2:1;
    unsigned char RA3:1;
    unsigned char RA4:1;
    unsigned char RA5:1;
    unsigned char :1;
    unsigned char :1;
  }; 
} @ 0x05;
__no_init volatile __bank0  union
{
  unsigned char PORTB;
  struct
  {
    unsigned char RB0:1;
    unsigned char RB1:1;
    unsigned char RB2:1;
    unsigned char RB3:1;
    unsigned char RB4:1;
    unsigned char RB5:1;
    unsigned char RB6:1;
    unsigned char RB7:1;
  }; 
} @ 0x06;
__no_init volatile __bank0  union
{
  unsigned char PORTC;
  struct
  {
    unsigned char RC0:1;
    unsigned char RC1:1;
    unsigned char RC2:1;
    unsigned char RC3:1;
    unsigned char RC4:1;
    unsigned char RC5:1;
    unsigned char RC6:1;
    unsigned char RC7:1;
  }; 
} @ 0x07;
__no_init volatile __nonbanked  unsigned char PCLATH @ 0x0A;
__no_init volatile __nonbanked  union
{
  unsigned char INTCON;
  struct
  {
    unsigned char RBIF:1;
    unsigned char INTF:1;
    unsigned char T0IF:1;
    unsigned char RBIE:1;
    unsigned char INTE:1;
    unsigned char T0IE:1;
    unsigned char PEIE:1;
    unsigned char GIE:1;
  }; 
} @ 0x0B;
__no_init volatile __bank0  union
{
  unsigned char PIR1;
  struct
  {
    unsigned char TMR1IF:1;
    unsigned char TMR2IF:1;
    unsigned char CCP1IF:1;
    unsigned char SSPIF:1;
    unsigned char TXIF:1;
    unsigned char RCIF:1;
    unsigned char ADIF:1;
    unsigned char :1;
  }; 
} @ 0x0C;
__no_init volatile __bank0  union
{
  unsigned char PIR2;
  struct
  {
    unsigned char CCP2IF:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char BCLIF:1;
    unsigned char EEIF:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  }; 
} @ 0x0D;
__no_init volatile __bank0      unsigned char TMR1L   @ 0x0E;
__no_init volatile __bank0      unsigned char TMR1H   @ 0x0F;
__no_init volatile __bank0  union
{
  unsigned char T1CON;
  struct
  {
    unsigned char TMR1ON:1;
    unsigned char TMR1CS:1;
    unsigned char T1SYNC:1;
    unsigned char T1OSCEN:1;
    unsigned char T1CKPS0:1;
    unsigned char T1CKPS1:1;
    unsigned char :1;
    unsigned char :1;
  }; 
} @ 0x10;
__no_init volatile __bank0      unsigned char TMR2    @ 0x11;
__no_init volatile __bank0  union
{
  unsigned char T2CON;
  struct
  {
    unsigned char T2CKPS0:1;
    unsigned char T2CKPS1:1;
    unsigned char TMR2ON:1;
    unsigned char TOUTPS0:1;
    unsigned char TOUTPS1:1;
    unsigned char TOUTPS2:1;
    unsigned char TOUTPS3:1;
    unsigned char :1;
  }; 
} @ 0x12;
__no_init volatile __bank0      unsigned char SSPBUF  @ 0x13;
__no_init volatile __bank0  union
{
  unsigned char SSPCON;
  struct
  {
    unsigned char SSPM0:1;
    unsigned char SSPM1:1;
    unsigned char SSPM2:1;
    unsigned char SSPM3:1;
    unsigned char CKP:1;
    unsigned char SSPEN:1;
    unsigned char SSPOV:1;
    unsigned char WCOL:1;
  }; 
} @ 0x14;
__no_init volatile __bank0      unsigned char CCPR1L  @ 0x15;
__no_init volatile __bank0      unsigned char CCPR1H  @ 0x16;
__no_init volatile __bank0  union
{
  unsigned char CCP1CON;
  struct
  {
    unsigned char CCP1M0:1;
    unsigned char CCP1M1:1;
    unsigned char CCP1M2:1;
    unsigned char CCP1M3:1;
    unsigned char CCP1Y:1;
    unsigned char CCP1X:1;
    unsigned char :1;
    unsigned char :1;
  }; 
} @ 0x17;
__no_init volatile __bank0  union
{
  unsigned char RCSTA;
  struct
  {
    unsigned char RX9D:1;
    unsigned char OERR:1;
    unsigned char FERR:1;
    unsigned char ADDEN:1;
    unsigned char CREN:1;
    unsigned char SREN:1;
    unsigned char RX9:1;
    unsigned char SPEN:1;
  }; 
} @ 0x18;
__no_init volatile __bank0      unsigned char TXREG   @ 0x19;
__no_init volatile __bank0      unsigned char RCREG   @ 0x1A;
__no_init volatile __bank0      unsigned char CCPR2L  @ 0x1B;
__no_init volatile __bank0      unsigned char CCPR2H  @ 0x1C;
__no_init volatile __bank0  union
{
  unsigned char CCP2CON;
  struct
  {
    unsigned char CCP2M0:1;
    unsigned char CCP2M1:1;
    unsigned char CCP2M2:1;
    unsigned char CCP2M3:1;
    unsigned char CCP2Y:1;
    unsigned char CCP2X:1;
    unsigned char :1;
    unsigned char :1;
  }; 
} @ 0x1D;
__no_init volatile __bank0      unsigned char ADRESH  @ 0x1E;
__no_init volatile __bank0  union
{
  unsigned char ADCON0;
  struct
  {
    unsigned char ADON:1;
    unsigned char :1;
    unsigned char GO:1;
    unsigned char CHS0:1;
    unsigned char CHS1:1;
    unsigned char CHS2:1;
    unsigned char ADCS0:1;
    unsigned char ADCS1:1;
  }; 
} @ 0x1F;

 

__no_init volatile __bank1  union
{
  unsigned char OPTION;
  struct
  {
    unsigned char PS0:1;
    unsigned char PS1:1;
    unsigned char PS2:1;
    unsigned char PSA:1;
    unsigned char T0SE:1;
    unsigned char T0CS:1;
    unsigned char INTEDG:1;
    unsigned char RBPU:1;
  }; 
} @ 0x81;
__no_init volatile __bank1      unsigned char TRISA   @ 0x85;
__no_init volatile __bank1      unsigned char TRISB   @ 0x86;
__no_init volatile __bank1      unsigned char TRISC   @ 0x87;
__no_init volatile __bank1  union
{
  unsigned char PIE1;
  struct
  {
    unsigned char TMR1IE:1;
    unsigned char TMR2IE:1;
    unsigned char CCP1IE:1;
    unsigned char SSPIE:1;
    unsigned char TXIE:1;
    unsigned char RCIE:1;
    unsigned char ADIE:1;
    unsigned char :1;
  }; 
} @ 0x8C;
__no_init volatile __bank1  union
{
  unsigned char PIE2;
  struct
  {
    unsigned char CCP2IE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char BCLIE:1;
    unsigned char EEIE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  }; 
} @ 0x8D;
__no_init volatile __bank1  union
{
  unsigned char PCON;
  struct
  {
    unsigned char BOR:1;
    unsigned char POR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  }; 
} @ 0x8E;
__no_init volatile __bank1  union
{
  unsigned char SSPCON2;
  struct
  {
    unsigned char SEN:1;
    unsigned char RSEN:1;
    unsigned char PEN:1;
    unsigned char RCEN:1;
    unsigned char ACKEN:1;
    unsigned char ACKDT:1;
    unsigned char ACKSTAT:1;
    unsigned char GCEN:1;
  }; 
} @ 0x91;
__no_init volatile __bank1      unsigned char PR2     @ 0x92;
__no_init volatile __bank1      unsigned char SSPADD  @ 0x93;
__no_init volatile __bank1  union
{
  unsigned char SSPSTAT;
  struct
  {
    unsigned char BF:1;
    unsigned char UA:1;
    unsigned char R:1;
    unsigned char S:1;
    unsigned char P:1;
    unsigned char D:1;
    unsigned char CKE:1;
    unsigned char SMP:1;
  }; 
} @ 0x94;
__no_init volatile __bank1  union
{
  unsigned char TXSTA;
  struct
  {
    unsigned char TX9D:1;
    unsigned char TRMT:1;
    unsigned char BRGH:1;
    unsigned char :1;
    unsigned char SYNC:1;
    unsigned char TXEN:1;
    unsigned char TX9:1;
    unsigned char CSRC:1;
  }; 
} @ 0x98;
__no_init volatile __bank1      unsigned char SPBRG   @ 0x99;
__no_init volatile __bank1      unsigned char ADRESL  @ 0x9E;
__no_init volatile __bank1  union
{
  unsigned char ADCON1;
  struct
  {
    unsigned char PCFG0:1;
    unsigned char PCFG1:1;
    unsigned char PCFG2:1;
    unsigned char PCFG3:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char ADFM:1;
  }; 
} @ 0x9F;

 

__no_init volatile __bank2      unsigned char EEDATA  @ 0x10C;
__no_init volatile __bank2      unsigned char EEADR   @ 0x10D;
__no_init volatile __bank2      unsigned char EEDATH  @ 0x10E;
__no_init volatile __bank2      unsigned char EEADRH  @ 0x10F;

 

__no_init volatile __bank3 union
{
  unsigned char EECON1;
  struct
  {
    unsigned char RD:1;
    unsigned char WR:1;
    unsigned char WREN:1;
    unsigned char WRERR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char EEPGD:1;
  }; 
} @ 0x18C;
__no_init volatile __bank3      unsigned char EECON2  @ 0x18D;













#pragma language=default




















 

__intrinsic void __disable_interrupt(void);
__intrinsic void __enable_interrupt(void);
__intrinsic void __no_operation(void);
__intrinsic void __clear_watchdog_timer(void);
__intrinsic void __sleep(void);
 
__intrinsic void __option(void);          
__intrinsic void __tris( unsigned char );
__intrinsic void __set_configuration_word( unsigned short value );

__intrinsic int  __flash_read_int( unsigned short address );
__intrinsic void __flash_write_int( unsigned short address, int value );
__intrinsic char __flash_read_low_char( unsigned short address );
__intrinsic char __flash_read_high_char( unsigned short address );


#pragma language=extended

const char katodRB[]=
    {0x00, 0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00};
const char katodRC[]=
    {0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
const char katodRA = 0x08;

__no_init __eeprom unsigned char ekatod, eanod;
__no_init __eeprom unsigned char edpmode, emasodperc;

__no_init __eeprom unsigned char eadjust, enulla;












__bank1 unsigned char BCD[6];
unsigned char bdigit, cdigit;
unsigned char a, b;
unsigned char h, m;
unsigned int clock_cnt;

unsigned char keytimer, muxtimer, muxe;
__bank1 unsigned char menucount;
__bank1 unsigned int dstmp;




__bank1 unsigned char katod, anod;
__bank1 unsigned char dpmode, masodperc, nulla;

__bank1 unsigned int adjust;


union
{
 unsigned char s;
 struct
 {
  unsigned char s0:1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
 };
};















  















  

union
{
 unsigned char lddata;
 struct
 {
  unsigned char dp1:1;
  unsigned char dp2:1;
  unsigned char :1;
  unsigned char :1;
  unsigned char :1;
  unsigned char showmenu:1;
  unsigned char clockshow:1;
  unsigned char clockshmode:1;
 };
};
 
union
{
 unsigned char keydata;
 struct
 {
  unsigned char key1press:1;
  unsigned char key2press:1;
  unsigned char key3press:1;
  unsigned char key1s:1;
  unsigned char key2s:1;
  unsigned char key3s:1;
  unsigned char :1;
  unsigned char ct:1;
 };
};
















 








  




















 

__bank1 union
{
 unsigned char ch1;
 struct
 {
  unsigned char chkatod:1;
  unsigned char chanod:1;
  unsigned char chdpmode:1;
  unsigned char chmasodperc:1;

  unsigned char chadjust:1;
  unsigned char chnulla:1;
  unsigned char :1;
  unsigned char :1;
 };
};


















 













void delay(unsigned int b)
{
 unsigned int a;
 
 for (a=0;a<b;a++) 
  {
  __no_operation(); 
  };

}


void multiplex(void)
{
 if (anod) PORTC &= 0xC0; 
  else PORTC |= 0x3F; 
 if (katod) PORTC &= 0x3F; 
  else PORTC |= 0xC0; 

 if (muxe<2){
  muxe++;
  return;
 }
 muxe=0;
 a=BCD[bdigit];
 if ((!(nulla)) && (!(showmenu)))
  if ((bdigit==5) && (a==0)) a = 10; 
 b=0;




 

 switch (bdigit)
 {
  case 2: if (dp1) b|= katodRA; break;
  case 4: if (dp2) b|= katodRA; break;
 };

 if (katod){ 
  PORTA&= 0xFF-katodRA;
  PORTA|= b; 
  } else { 
     PORTA|= katodRA;
     b^= 0xFF;
     PORTA&= b; 
    }
 b=0;
 b = katodRC[a];
 a = katodRB[a];
 

 if (katod) { 

  PORTC |= b; 
  PORTB = a; 
  } else { 

     b^= 0xFF;
     PORTC &= b; 
     a^= 0xFF;
     PORTB = a; 
    }
 
 
 a=1;
 a= a << bdigit;
 if (anod) PORTC|= a; 
  else { 
    a^= 0xFF;
    a&= 0x3F;
    PORTC&= a;
   }

  if (bdigit==5) 
  {
   if (!(showmenu)) {
    if (masodperc) bdigit = 0; 
     else bdigit = 2; 
   } else bdigit = 0; 
  } else
   {
    bdigit++;
   } 
}

void step_clock(void)
{
 if (clock_cnt==(1937+adjust))  
  {
   clock_cnt= 0;
   if (s==59)
    {
     s= 0;
     if (m==59)
      {
       m= 0;
       if (h==23)
        {
         h= 0;
        } else h++;
      } else m++;
    } else s++;
  } else clock_cnt++;
}









 

void checkkeypress(void)
{
 if (keytimer==30) 
  { 
   keytimer= 0;
   if (RA2) { key1s= 1; }
   if (RA1) { key2s= 1; }
   if (RA0) { key3s= 1; }
    
   if (!RA2)
    {
     if (key1s) 
      {
       key1press= 1;
       key1s= 0;
      }
     } 

   if (!RA1)
    {
     if (key2s) 
      {
       key2press= 1;
       key2s= 0;
      }
     } 

   if (!RA0)
    {
     if (key3s) 
      {
       key3press= 1;
       key3s= 0;
      }
     } 

  } else keytimer++;
}


#pragma vector=0x4
__interrupt void intserv(void)
{
 if (T0IF) T0IF=0;





 
 if (muxtimer==1){
   multiplex();
   muxtimer=0;
   } else muxtimer++;
 step_clock();

 checkkeypress();
}


void itobcd(unsigned int i, unsigned char d, unsigned char s)
{
 unsigned int ii;
 unsigned char ss;
 

 ii= i;
 ss= 0;
 while (ii)
 {
  BCD[d]= ii % 10;
  ii/= 10;
  d++;
  ss++;
  if (ss==s) break;
 } 
 while (ss!=s)
  {
   BCD[d]= 0;
   d++;
   ss++;
  }
}


void readfrom(void)
{

 katod = ekatod;
 anod = eanod;
 dpmode = edpmode;
 masodperc = emasodperc;
 adjust = eadjust;
 nulla = enulla;
}


void writeto(void)
{
 unsigned char tp;
  
 BCD[4]= 0x09;
 BCD[5]= 0x09;
 tp= 1;
 itobcd(tp, 0, 2);
 if (chkatod)  
 {
  delay(30000);
  ekatod=  katod;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chanod)
 {
  delay(30000);
  eanod= anod;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chdpmode) 
 {
  delay(30000);
  edpmode=  dpmode;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chmasodperc)
 {
  delay(30000);
  emasodperc= masodperc;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chadjust) 
 {
  delay(30000);
  eadjust=  adjust;
 }
 tp++;
 itobcd(tp, 0, 2);
 if (chnulla) 
 {
  delay(30000);
  enulla=  nulla;
 }
 ch1= 0;

}

void writeall(void)
{
 ch1= 0xFF;

 writeto();
}


void setdefaults(void)
{
 katod = 1;;
 anod = 1;;
 dpmode =  3;;
 masodperc = 1;;
 adjust = 16;;
 nulla = 1;;
 writeall();
}

void display(void)
{
 if (!showmenu)
  {

   itobcd(m, 2, 2);
   itobcd(h, 4, 2);
   itobcd(s, 0, 2);
   switch (dpmode)
   {
    case 0: {
             dp1 = 0;
             dp2 = 0;
             break;
            } 
    case 1: {
             dp1 = 0;
             dp2 = !s0;
             break;
            } 
    case 2: {
             dp1 = !s0;
             dp2 = 0;
             break;
            } 
    case 3: {
             dp1 = 1;
             dp2 = !s0;
             break;
            } 
    case 4: {
             dp1 = !s0;
             dp2 = 1;
             break;
            } 
    
   }
 } else {
         if (menucount==7) dstmp = s;
         itobcd(dstmp, 2, 2);
        }
}

void key1handler(void)
{
 if (menucount==0)
  {
   menucount= 9;
   showmenu= 1;
   dp1= 0;
   dp2= 1;
   BCD[0]= 0x0A;
   BCD[1]= 0x0A;  

   
  } else menucount--;

 switch (menucount)
 {
  case 9: {
                 BCD[5]= 0x00;
                 BCD[4]= 0x01;  
                 dstmp= h;
                 break;
                }
  case 8:{
                 BCD[5]= 0x00;
                 BCD[4]= 0x02;  
                 dstmp= m;
                 break;
                }
  case 7: {
                 BCD[5]= 0x00;
                 BCD[4]= 0x03;  
                 dstmp= s;
                 break;
                }
  case 6: {
                 BCD[5]= 0x00;
                 BCD[4]= 0x04;  
                 dstmp= katod;
                 break;
                }
  case 5:  {
                 BCD[5]= 0x00;
                 BCD[4]= 0x05;  
                 dstmp= anod;
                 break;
                }
  case 4:  {
                 BCD[5]= 0x00;
                 BCD[4]= 0x06;  
                 dstmp= dpmode;
                 break;
                }
  case 3:   {
                 BCD[5]= 0x00;
                 BCD[4]= 0x07;  
                 dstmp= masodperc;
                 break;
                }
  case 2:    {
                 BCD[5]= 0x00;
                 BCD[4]= 0x08;  
                 dstmp= adjust;
                 break;
                }
  case 1:    {
                 BCD[5]= 0x00;
                 BCD[4]= 0x09;  
                 dstmp= nulla;
                 break;
                }
 };

 if (menucount==0)
 {
  showmenu = 0;
  writeto();
 } 
}

void key2handler(void)
{
 if (!showmenu)
 {
  if (clockshow)
  {
   clockshmode= !clockshmode;
  } else
    {



    }
 } else
   {
 switch (menucount)
 {
  case 9: {     if (h>0) h--;
                 dstmp = h;
                 break;
                }
  case 8:{      if (m>0) m--;
                 dstmp = m;
                 break;
                }
  case 7: {     
                 break;
                }
  case 6: {     if (katod>0) katod--;
                 chkatod= 1;
                 dstmp= katod;
                 break;
                }
  case 5:  {     if (anod>0) anod--;
                 chanod= 1;
                 dstmp= anod;
                 break;
                }
  case 4:  {     if (dpmode>0) dpmode--;
                 chdpmode= 1;
                 dstmp= dpmode;
                 break;
                }
  case 3:   {     if (masodperc>0) masodperc--;
                 chmasodperc= 1;
                 dstmp= masodperc;
                 break;
                }
  case 2:    {   if (adjust>1) adjust--; 
                 clock_cnt = 0;
                 chadjust= 1;
                 dstmp= adjust;
                 break;
                }
  case 1:   {     if (nulla>0) nulla--;
                 chnulla= 1;
                 dstmp= nulla;
                 break;
                }
 };
   }
}

void key3handler(void)
{
 if (!showmenu)
 {
  clockshow= !clockshow;
 } else
    {
 switch (menucount)
 {
  case 9: {     if (h<23) h++;
                 dstmp= h;
                 break;
                }
  case 8:{     if (m<59) m++;
                 dstmp= m;
                 break;
                }
  case 7: {      s = 0;
                 clock_cnt= 0;
                 dstmp= s;
                 break;
                }
  case 6: {     if (katod<1) katod++;
                 chkatod= 1;
                 dstmp= katod;
                 break;
                }
  case 5:  {     if (anod<1) anod++;
                 chanod= 1;
                 dstmp= anod;
                 break;
                }
  case 4:  {     if (dpmode<4) dpmode++;
                 chdpmode= 1;
                 dstmp= dpmode;
                 break;
                }
  case 3:   {    if (masodperc<1) masodperc++;
                 chmasodperc= 1;
                 dstmp= masodperc;
                 break;
                }
  case 2:    {   if (adjust<31) adjust++; 
                 clock_cnt = 0;
                 chadjust= 1;
                 dstmp= adjust;
                 break;
                }
  case 1:   {    if (nulla<1) nulla++;
                 chnulla= 1;
                 dstmp= nulla;
                 break;
                }
 };
  } 
}

void keyhandler(void)
{
 if (key1press)
 {
  key1press= 0;
  key1handler();
 }
 if (key2press)
 {
  key2press= 0;
  key2handler();
 }
 if (key3press)
 {
  key3press= 0;
  key3handler();
 }
}

void main(void)
{
__set_configuration_word(0x3F7A);

 
 TRISC=0;
 TRISB=0;
 OPTION=0; 
 ADCON1=0x07;
 PORTB=0;
 PORTC=0;
 bdigit=0;
 cdigit=0;
 TMR0=0;
 

 EEIE=0;


 PEIE=1;

 keytimer= 0;
 muxtimer=0;
 muxe=0;

 menucount= 0;




  

 h= 0;
 m= 0;
 s= 0;
 clock_cnt= 0;  
 TRISA= 0x37;

 
 BCD[0]=0x00;
 BCD[1]=0x00;
 BCD[2]=0x00;
 BCD[3]=0x00;
 BCD[4]=0x00;
 BCD[5]=0x00;

 if (!RA1) 
 {
  while (!RA1) ;
  T0IE=1;
  GIE=1;
  delay(40000);
  setdefaults();
  BCD[0]=0x08;
  BCD[1]=0x08;
  BCD[2]=0x08;
  BCD[3]=0x08;
  BCD[4]=0x08;
  BCD[5]=0x08;
  delay(50000);
 } else readfrom();
 
 T0IE=1;
 GIE=1;


 clockshmode= 1;
 clockshow= 1;
 showmenu= 0;

  

 
 while (1)
 {
  keyhandler();
  display();  









 
 }

}


